/* --------------------------------------------------------------
  ConfigApi.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

import Ajax from '../libs/Ajax';

export default {
	/**
	 * Get StyleEdit Config Values
	 *
	 * The administrator can set some hardcoded values in the config.inc.php which can be retrieved with this
	 * API method. Not every config value will included though due to security concerns.
	 *
	 * @return {jQuery.jqXHR}
	 */
	get() {
		const ajaxUrl = StyleEdit.Config.get('baseUrl') + '/api.php/templates/' + StyleEdit.Config.get('template')
			+ '/config';
		
		return Ajax.get(ajaxUrl, {theme: StyleEdit.Config.get('theme') || undefined}, {dataType: 'json'});
	}
}
